
	// Filter WindowShades
__kernel void filter_WindowShades(__read_only image2d_t image,		// image buffer input
								  __read_only image2d_t merge,		// merge buffer input
								  __write_only image2d_t retImg,   	// image buffer output
								  __private float m_mergeAlpha,
								  __private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

	float2 uv = (float2)((float)(w) / width, (float)(h) / height);
	float4 orignalColor = read_imagef(image, sampler, uv); // bgra
	float4 overlayColor = read_imagef(merge, sampler, uv); // bgra
	float sa = overlayColor.w * m_mergeAlpha;
	float da = 1.0f - sa;
	float4 fragColor = orignalColor * da + overlayColor * sa;
	fragColor.w = orignalColor.w;
	
	float factor = (float)(alpha)/100.0f;
	fragColor = fragColor * factor + (1.0f - factor) * orignalColor;
	
	write_imagef(retImg, (int2)(w, h), fragColor);
}


